/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipeSimple;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Heating")
@ZenRegister
public class CTHeating {
    @ZenMethod
    public static void addRecipe(String registryName, IItemStack input, IItemStack output, float transformTemp, float maxTemp) {
        if (input == null || output == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty!");
        }
        ItemStack istack = (ItemStack)input.getInternal();
        ItemStack ostack = (ItemStack)output.getInternal();
        IItemHeat icap = (IItemHeat)istack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        if (icap == null) {
            throw new IllegalStateException("Input must have heating capabilities!");
        }
        final HeatRecipe recipe = (HeatRecipe)new HeatRecipeSimple(IIngredient.of(istack), ostack, transformTemp, maxTemp, Metal.Tier.TIER_I).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.HEAT.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding heating recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TFCRegistries.HEAT.getValuesCollection().stream().filter(x -> x instanceof HeatRecipeSimple).filter(x -> ((ItemStack)x.getOutputs().get(0)).func_77969_a(item)).forEach(removeList::add);
        for (final HeatRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.HEAT;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing heating recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final HeatRecipe recipe = (HeatRecipe)TFCRegistries.HEAT.getValue(new ResourceLocation(registryName));
        if (recipe instanceof HeatRecipeSimple) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.HEAT;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing heating recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

